package org.clazzes.fancymail.server.dao.jdbc;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.clazzes.fancymail.sending.EMailEngine;

public class EmailThreadInterceptor implements MethodInterceptor {
    
    private EMailEngine emailEngine;
    public void setEMailEngine(EMailEngine emailEngine) {
        this.emailEngine = emailEngine;
    }
    
    public Object invoke(MethodInvocation invocation) throws Throwable {
        
        try {
            Object ret = invocation.proceed();
            
            if ("insertEMail".equals(invocation.getMethod().getName())) {
                this.emailEngine.wake();                
            }
            
            return ret;            
        } finally {
        }
    }    

}
