/***********************************************************
 * $Id$
 * 
 * FancyMail standalone OSGi server of the clazzes.org project
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.fancymail.server.dao.jdbc;

import java.util.HashMap;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.clazzes.fancymail.server.entities.EMail;
import org.clazzes.fancymail.server.entities.EMailSender;
import org.clazzes.util.aop.ThreadLocalManager;

/**
 * An interceptor for attaching a thread-bound map of {@link EMailSender}
 * objects.
 */
public class EMailSenderCacheInterceptor implements MethodInterceptor {

    public static final String SENDER_CACHE_KEY = "org.clazzes.fancymail.server::EMailSenderCache";
    public static final String EMAIL_CACHE_KEY = "org.clazzes.fancymail.server::EMailCache";
    
    /* (non-Javadoc)
     * @see org.aopalliance.intercept.MethodInterceptor#invoke(org.aopalliance.intercept.MethodInvocation)
     */
    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
       
        ThreadLocalManager.bindResource(SENDER_CACHE_KEY,new HashMap<Long,EMailSender>());
        ThreadLocalManager.bindResource(EMAIL_CACHE_KEY,new HashMap<Long,EMail>());
        
        try {
            return invocation.proceed();
        }
        finally {
            ThreadLocalManager.unbindResource(EMAIL_CACHE_KEY);
            ThreadLocalManager.unbindResource(SENDER_CACHE_KEY);
        }
    }

}
