package org.clazzes.fancymail.server.dao;

import java.util.Date;
import java.util.List;

import org.clazzes.fancymail.server.entities.SMS;
import org.clazzes.util.sql.dao.IIdDAO;

public interface SMSDAO extends IIdDAO<SMS> {

    List<SMS> getAllByStatus(int status, int maxCount);


   /**
     * Return up to <code>maxCount</code> SMSes to send by <code>SELECT FOR UPDATE</code>.
     * @param status The status of the SMSes to retrieve.
     * @param maxCount The maximal number of mails to return.
     * @return A list of SMSes with the given status.
     */
    List<SMS> getAllByStatusForUpdate(int status, int maxCount);

    /**
     * <p>Return up to <code>maxCount</code> SMSes being in status
     * <code>SENDING</code> and started to be in this status before
     * the given point in time.</p>
     *
     * <p>This call uses <code>SELECT FOR UPDATE</code> in order to
     * </p>
     *
     * @param before The point in time before the returned mail should have been processed.
     * @param maxCount The maximal number of mails to return.
     * @return A list of SMSes, which which are in the sending state since a point
     *         in time before the given timestamp.
     */
    List<SMS> getStaleSending(Date before, int maxCount);

    List<SMS> getAllInRange(Date from, Date to);

    List<SMS> getAllForRecipient(String recipient, Date from, Date to);

    List<SMS> getAllForSender(String sender, Date from, Date to);

    List<SMS> getAllForSenderRecipient(String sender, String recipient, Date from, Date to);

    List<Long> getOutdatedIds(Date to);

    void deleteByIds(List<Long> ids);
}
