/***********************************************************
 * $Id$
 * 
 * FancyMail standalone OSGi server of the clazzes.org project
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.fancymail.server.dao;

import java.util.Collection;
import java.util.List;

import org.clazzes.fancymail.server.entities.EMail;
import org.clazzes.fancymail.server.entities.EMailRecipient;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.dao.IIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;

/**
 * DAO for e-mail senders.
 */
public interface EMailRecipientDAO extends IIdDAO<EMailRecipient> {

    /**
     * Add all recipients for a list of given email entities with the
     * given condition.
     * @param emails The list of selected emails.
     * @param condition The condition used to fetch the list of emails.
     * @param preparer The preparer to fill in placeholders to
     *                 the given condition. 
     */
    void fetchAllForEMails(Collection<EMail> emails,
            SQLCondition condition, StatementPreparer preparer);

    /**
     * @param emailIds The list of IDs of {@link EMail} entities.
     * @return The number of recipients deleted for each mail.
     */
    int[] deleteAllForEMails(List<Long> emailIds);
}
