/***********************************************************
 * $Id$
 * 
 * FancyMail standalone OSGi server of the clazzes.org project
 * http://www.clazzes.org
 *
 * Created: 06.05.2018
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.fancymail.server.dao;

import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.dao.StatementPreparer;

/**
 * An interface for extending EMail objects with additonal data like attaachments.
 */
public interface EMailExtender {

    /**
     * Amend all emails that would have been returned by the given
     * condition.
     * @param condition The condition on the email table.
     * @param preparer Statement preparer to set. 
     */
    void amendEMails(SQLCondition condition,
            StatementPreparer preparer);
}
