/***********************************************************
 * $Id: EMailDAO.java 212 2013-10-04 11:55:31Z fancymail $
 *
 * FancyMail standalone OSGi server of the clazzes.org project
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***********************************************************/

package org.clazzes.fancymail.server.dao;

import java.util.List;

import org.clazzes.fancymail.server.entities.EMailAttachment;
import org.clazzes.util.sql.dao.IIdDAO;

/**
 * DAO for email attachments.
 */
public interface EMailAttachmentDAO extends IIdDAO<EMailAttachment>, EMailExtender {

    /**
     * @param emailId The ID of an email.
     * @return All email attachments for the given email ID.
     */
    List<EMailAttachment> getAllForEMail(Long emailId);

    /**
     * @param emailIds A list of IDs of emails.
     */
    public void deleteAllForEMails(List<Long> emailIds);
}
