/***********************************************************
 * $Id$
 * 
 * FancyMail standalone OSGi server of the clazzes.org project
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.fancymail.server.api;

/**
 * An email sender for the external API with an address and an optional replyTo name.
 */
public class EMailSenderDTO extends EMailAddressDTO {

    private static final long serialVersionUID = -3313405494696201604L;
    
    private String replyTo;

    /**
     * @return the optional RFC822 replyTo address.
     */
    public String getReplyTo() {
        return this.replyTo;
    }

    /**
     * @param replyTo the optional RFC822 replyTo address to set.
     */
    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

}
