/***********************************************************
 * $Id$
 * 
 * FancyMail standalone OSGi server of the clazzes.org project
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.fancymail.server.api;

import java.util.Date;

/**
 * An email DTO as used when reporting the status of an email.
 */
public class EMailReportDTO extends EMailDTO {

    private static final long serialVersionUID = -228583241619466232L;

    private String status;
    private int errorCount;
    private String lastErrorText;
    private Date sentAt;
    private Date created;
    /**
     * @return the status
     */
    public String getStatus() {
        return this.status;
    }
    /**
     * @param status the status to set
     */
    public void setStatus(String status) {
        this.status = status;
    }
    /**
     * @return the errorCount
     */
    public int getErrorCount() {
        return this.errorCount;
    }
    /**
     * @param errorCount the errorCount to set
     */
    public void setErrorCount(int errorCount) {
        this.errorCount = errorCount;
    }
    /**
     * @return the lastErrorText
     */
    public String getLastErrorText() {
        return this.lastErrorText;
    }
    /**
     * @param lastErrorText the lastErrorText to set
     */
    public void setLastErrorText(String lastErrorText) {
        this.lastErrorText = lastErrorText;
    }
    /**
     * @return the sentAt
     */
    public Date getSentAt() {
        return this.sentAt;
    }
    /**
     * @param sentAt the sentAt to set
     */
    public void setSentAt(Date sentAt) {
        this.sentAt = sentAt;
    }
    /**
     * @return the created
     */
    public Date getCreated() {
        return this.created;
    }
    /**
     * @param created the created to set
     */
    public void setCreated(Date created) {
        this.created = created;
    }


    
    
}
