/***********************************************************
 * $Id$
 * 
 * FancyMail standalone OSGi server of the clazzes.org project
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.fancymail.server.api;

import java.io.Serializable;
import java.util.List;

/**
 * An EMail DTO as used when scheduling a new e-mail.
 */
public class EMailDTO implements Serializable {

    private static final long serialVersionUID = 6785372209555852724L;

    private String subject;
    private String body;
    private String sender;

    private List<EMailAddressDTO> to;
    private List<EMailAddressDTO> cc;
    private List<EMailAddressDTO> bcc;
    
    /**
     * @return the subject
     */
    public String getSubject() {
        return this.subject;
    }
    /**
     * @param subject the subject to set
     */
    public void setSubject(String subject) {
        this.subject = subject;
    }
    /**
     * @return the body
     */
    public String getBody() {
        return this.body;
    }
    /**
     * @param body the body to set
     */
    public void setBody(String body) {
        this.body = body;
    }
    /**
     * @return the sender as an RFC882 e-mail address. Please note, that the
     *          has to be configured in the database before using it as sender of a
     *          new e-mail.
     */
    public String getSender() {
        return this.sender;
    }
    /**
     * @param sender the sender to set
     */
    public void setSender(String sender) {
        this.sender = sender;
    }
    /**
     * @return the list of <code>To:</code> recipients of an e-mail.
     */
    public List<EMailAddressDTO> getTo() {
        return this.to;
    }
    /**
     * @param to the list of <code>To:</code> recipients of an e-mail to set
     */
    public void setTo(List<EMailAddressDTO> to) {
        this.to = to;
    }
    /**
     * @return the list of <code>CC:</code> recipients of an e-mail.
     */
    public List<EMailAddressDTO> getCc() {
        return this.cc;
    }
    /**
     * @param cc the list of <code>CC:</code> recipients of an e-mail to set
     */
    public void setCc(List<EMailAddressDTO> cc) {
        this.cc = cc;
    }
    /**
     * @return the list of <code>BCC:</code> recipients of an e-mail.
     */
    public List<EMailAddressDTO> getBcc() {
        return this.bcc;
    }
    /**
     * @param bcc the list of <code>BCC:</code> recipients of an e-mail to set
     */
    public void setBcc(List<EMailAddressDTO> bcc) {
        this.bcc = bcc;
    }
    
}
