/***********************************************************
 * $Id$
 * 
 * FancyMail standalone OSGi server of the clazzes.org project
 * http://www.clazzes.org
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 ***********************************************************/

package org.clazzes.fancymail.server.api;

import java.io.Serializable;


/**
 * An email Address for the external API with an address and an optional personal name.
 */
public class EMailAddressDTO implements Serializable {

    private static final long serialVersionUID = -1665798058862323927L;

    private String personalName;
    private String address;

    /**
     * @return the optional personal name, which is put as additional information
     *           alongside the e-mail address.
     */
    public String getPersonalName() {
        return this.personalName;
    }
    /**
     * @param personalName the personalName to set
     */
    public void setPersonalName(String personalName) {
        this.personalName = personalName;
    }
    /**
     * @return the RFC822 e-mail address.
     */
    public String getAddress() {
        return this.address;
    }
    /**
     * @param address the RFC822 e-mail address to set
     */
    public void setAddress(String address) {
        this.address = address;
    }
}
