/*
 * Decompiled with CFR 0.152.
 */
package org.clazzes.fancymail.cmd;

import java.io.PrintStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.clazzes.fancymail.server.api.EMailAddressDTO;
import org.clazzes.fancymail.server.api.EMailDTO;
import org.clazzes.fancymail.server.api.EMailReportDTO;
import org.clazzes.fancymail.server.api.EMailSenderDTO;
import org.clazzes.fancymail.server.api.FancyMailServerSMSService;
import org.clazzes.fancymail.server.api.FancyMailServerService;
import org.clazzes.fancymail.server.api.SMSDTO;
import org.clazzes.fancymail.server.api.SMSDestinationDTO;
import org.clazzes.fancymail.server.api.SMSReportDTO;
import org.clazzes.fancymail.server.api.SMSSenderDTO;
import org.clazzes.svc.api.cmd.Argument;
import org.clazzes.svc.api.cmd.CommandSet;
import org.clazzes.svc.api.cmd.Descriptor;
import org.clazzes.svc.api.cmd.Parameter;
import org.clazzes.util.datetime.ISO8601Format;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FancymailCommands
implements CommandSet {
    private static final Logger log = LoggerFactory.getLogger(FancymailCommands.class);
    private static final List<String> FUNCTIONS = List.of("listMailSenders", "insertMailSender", "sendMail", "listMails", "listSMSSenders", "insertSMSSender", "sendSMS", "listSMSs");
    private static final String NULL_STRING = "\u00a0";
    public static final Pattern PHONE_NR_REGEX = Pattern.compile("\\+[0-9]{8,14}");
    private static final ISO8601Format DF = new ISO8601Format(ISO8601Format.DATETIME_FORMAT_NO_TZ, TimeZone.getDefault());
    private FancyMailServerService fancyMailServerService;
    private FancyMailServerSMSService fancyMailServerSMSService;

    public List<String> getCommands() {
        return FUNCTIONS;
    }

    public synchronized FancyMailServerService getFancyMailServerService() {
        return this.fancyMailServerService;
    }

    public synchronized void fancyMailServerServiceBound(FancyMailServerService fancyMailServerService) {
        log.info("fancymail service became available, fancymail:* GoGO commands for email services will be activated.");
        this.fancyMailServerService = fancyMailServerService;
    }

    public synchronized void fancyMailServerServiceUnbound(FancyMailServerService fancyMailServerService) {
        log.info("fancymail service disappeared, fancymail:* GoGO commands will fail for email services.");
        this.fancyMailServerService = null;
    }

    public synchronized FancyMailServerSMSService getFancyMailServerSMSService() {
        return this.fancyMailServerSMSService;
    }

    public synchronized void fancyMailServerSMSServiceBound(FancyMailServerSMSService fancyMailServerSMSService) {
        log.info("fancymail sms service became available, fancymail:* GoGO commands for sms services will be activated.");
        this.fancyMailServerSMSService = fancyMailServerSMSService;
    }

    public synchronized void fancyMailServerSMSServiceUnbound(FancyMailServerSMSService fancyMailServerSMSService) {
        log.info("fancymail sms service disappeared, fancymail:* GoGO commands will fail for SMS services.");
        this.fancyMailServerSMSService = null;
    }

    private static void replicate(StringBuffer sb, char c, int n) {
        for (int i = 0; i < n; ++i) {
            sb.append(c);
        }
    }

    private static void padLeft(StringBuffer sb, String s, int width) {
        if (s != null) {
            if (s.length() > width) {
                sb.append(s.substring(0, width - 1));
                sb.append("\u2026");
            } else {
                sb.append(s);
                FancymailCommands.replicate(sb, ' ', width - s.length());
            }
        } else {
            FancymailCommands.replicate(sb, ' ', width);
        }
    }

    private static void padRight(StringBuffer sb, String s, int width) {
        if (s != null) {
            if (s.length() > width) {
                sb.append(s.substring(0, width - 1));
                sb.append("\u2026");
            } else {
                FancymailCommands.replicate(sb, ' ', width - s.length());
                sb.append(s);
            }
        } else {
            FancymailCommands.replicate(sb, ' ', width);
        }
    }

    @Descriptor(value="List mail senders.")
    public void listMailSenders(PrintStream out) throws Exception {
        FancyMailServerService svc = this.getFancyMailServerService();
        List senders = svc.getAllSenders();
        int mailWidth = 20;
        int prettyWidth = 20;
        int replyToWidth = 20;
        for (EMailSenderDTO sender : senders) {
            if (sender.getAddress() != null && sender.getAddress().length() > mailWidth) {
                mailWidth = sender.getAddress().length();
            }
            if (sender.getPersonalName() != null && sender.getPersonalName().length() > prettyWidth) {
                prettyWidth = sender.getPersonalName().length();
            }
            if (sender.getReplyTo() == null || sender.getReplyTo().length() <= replyToWidth) continue;
            replyToWidth = sender.getReplyTo().length();
        }
        StringBuffer sb = new StringBuffer();
        sb.append('+');
        FancymailCommands.replicate(sb, '-', mailWidth + 2);
        sb.append('+');
        FancymailCommands.replicate(sb, '-', prettyWidth + 2);
        sb.append('+');
        FancymailCommands.replicate(sb, '-', replyToWidth + 2);
        sb.append('+');
        String headLine = sb.toString();
        out.println(headLine);
        sb.setLength(0);
        sb.append("| ");
        FancymailCommands.padRight(sb, "E-Mail", mailWidth);
        sb.append(" | ");
        FancymailCommands.padLeft(sb, "Pretty Name", prettyWidth);
        sb.append(" | ");
        FancymailCommands.padRight(sb, "Reply To", replyToWidth);
        sb.append(" |");
        out.println(sb.toString());
        out.println(headLine);
        for (EMailSenderDTO sender : senders) {
            sb.setLength(0);
            sb.append("| ");
            FancymailCommands.padRight(sb, sender.getAddress(), mailWidth);
            sb.append(" | ");
            FancymailCommands.padLeft(sb, sender.getPersonalName(), prettyWidth);
            sb.append(" | ");
            FancymailCommands.padRight(sb, sender.getReplyTo(), replyToWidth);
            sb.append(" |");
            out.println(sb.toString());
        }
        out.println(headLine);
        out.println(String.format("Found [%d] e-mail senders.", senders.size()));
    }

    @Descriptor(value="Insert a mail sender.")
    public void insertMailSender(PrintStream out, @Descriptor(value="Reply-To Address") @Parameter(names={"-r", "--reply"}, absentValue="\u00a0") String replyTo, @Descriptor(value="e-mail Address") @Argument(value="email") String address, @Descriptor(value="Pretty Name") @Argument(value="gecos") String pretty) {
        EMailSenderDTO sender = new EMailSenderDTO();
        sender.setAddress(address);
        sender.setPersonalName(pretty);
        if (!NULL_STRING.equals(replyTo)) {
            sender.setReplyTo(replyTo);
        }
        FancyMailServerService svc = this.getFancyMailServerService();
        svc.insertSender(sender);
        out.println("Successfully inserted e-mail sender for [" + address + "]");
    }

    private static EMailAddressDTO parseEMailAddress(String addr) {
        String trimmed = addr.trim();
        EMailAddressDTO ret = new EMailAddressDTO();
        if (trimmed.endsWith(">")) {
            int idx = trimmed.indexOf("<", 0);
            if (idx < 0) {
                throw new IllegalArgumentException("EMail Address [" + addr + "] ends with '>'' but does not contain '<'");
            }
            ret.setAddress(trimmed.substring(idx + 1, trimmed.length() - 1).trim());
            ret.setPersonalName(trimmed.substring(0, idx).trim());
        } else {
            ret.setAddress(trimmed);
        }
        if (!ret.getAddress().contains("@")) {
            throw new IllegalArgumentException("EMail Address [" + addr + "] does not contain '@'");
        }
        return ret;
    }

    private static List<EMailAddressDTO> parseEMailAddressList(String addr) {
        String[] parts = addr.trim().split("\\s*,\\s*");
        ArrayList<EMailAddressDTO> ret = new ArrayList<EMailAddressDTO>(parts.length);
        for (String part : parts) {
            if (part.length() <= 0) continue;
            ret.add(FancymailCommands.parseEMailAddress(part));
        }
        if (ret.size() == 0) {
            throw new IllegalArgumentException("EMail Address list [" + addr + "] does not contain any e-mail.");
        }
        return ret;
    }

    private static String formatEmailListShort(List<EMailAddressDTO> addrs) {
        StringBuffer sb = new StringBuffer();
        for (EMailAddressDTO addr : addrs) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(addr.getAddress());
        }
        return sb.toString();
    }

    @Descriptor(value="Send a mail, some fields may be a comma-separated list of e-mail adresses.")
    public void sendMail(PrintStream out, @Descriptor(value="CC Address(es)") @Parameter(names={"-c", "--cc"}, absentValue="\u00a0") String cc, @Descriptor(value="BCC Address(es)") @Parameter(names={"-C", "--bcc"}, absentValue="\u00a0") String bcc, @Descriptor(value="Sender e-mail Address") @Argument(value="from") String from, @Descriptor(value="Recipient e-mail Address(es)") @Argument(value="to") String to, @Descriptor(value="Subject") @Argument(value="subject") String subject, @Descriptor(value="Message Body") @Argument(value="body") String body) {
        EMailDTO email = new EMailDTO();
        email.setTo(FancymailCommands.parseEMailAddressList(to));
        if (!NULL_STRING.equals(cc)) {
            email.setCc(FancymailCommands.parseEMailAddressList(cc));
        }
        if (!NULL_STRING.equals(bcc)) {
            email.setBcc(FancymailCommands.parseEMailAddressList(bcc));
        }
        email.setSender(from);
        email.setSubject(subject);
        email.setBody(body);
        FancyMailServerService svc = this.getFancyMailServerService();
        svc.queueMail(email);
        out.println("Sucessfully queued mail to [" + to + "]");
    }

    private Date parseDate(String s) throws ParseException {
        Calendar c = (Calendar)DF.parseObject(s);
        return new Date(c.getTimeInMillis());
    }

    private String formatDate(Date d) {
        if (d == null) {
            return "";
        }
        GregorianCalendar c = new GregorianCalendar();
        c.setTimeInMillis(d.getTime());
        return d == null ? "" : DF.format((Object)c);
    }

    private Date defaultDate(PrintStream out) {
        GregorianCalendar c = new GregorianCalendar();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        ((Calendar)c).add(5, -14);
        out.println("Using default start date [" + DF.format((Object)c) + "].");
        return new Date(c.getTimeInMillis());
    }

    @Descriptor(value="List E-Mails from database.")
    public void listMails(PrintStream out, @Descriptor(value="Start date to search for, default is two weeks before today") @Parameter(names={"-s", "--since"}, absentValue="\u00a0") String since, @Descriptor(value="End date to search for, default is no upper date limit") @Parameter(names={"-u", "--until"}, absentValue="\u00a0") String until, @Descriptor(value="Sender e-mail Address to search for") @Parameter(names={"-f", "--from"}, absentValue="\u00a0") String from, @Descriptor(value="Recipient e-mail Address to search for") @Parameter(names={"-t", "--to"}, absentValue="\u00a0") String to, @Descriptor(value="Maximal width of output columns") @Parameter(names={"-w", "--width"}, absentValue="40") int maxWidth) throws ParseException {
        Date sinceDate = NULL_STRING.equals(since) ? this.defaultDate(out) : this.parseDate(since);
        Date untilDate = NULL_STRING.equals(until) ? null : this.parseDate(until);
        FancyMailServerService svc = this.getFancyMailServerService();
        List mails = svc.getAllEMails(sinceDate, untilDate, NULL_STRING.equals(from) ? null : from, NULL_STRING.equals(to) ? null : to);
        int fromWidth = 20;
        int toWidth = 20;
        int dateWidth = 19;
        int sentWidth = 19;
        int subjectWidth = 20;
        int statusWidth = 20;
        for (EMailReportDTO mail : mails) {
            if (fromWidth < maxWidth && mail.getSender().length() > fromWidth) {
                fromWidth = Math.min(mail.getSender().length(), maxWidth);
            }
            int w = -1;
            for (EMailAddressDTO toAddr : mail.getTo()) {
                w += 1 + toAddr.getAddress().length();
            }
            if (w > toWidth) {
                toWidth = Math.min(w, maxWidth);
            }
            if (subjectWidth < maxWidth && mail.getSubject().length() > subjectWidth) {
                subjectWidth = Math.min(mail.getSubject().length(), maxWidth);
            }
            if (statusWidth >= maxWidth || mail.getStatus().length() <= statusWidth) continue;
            statusWidth = Math.min(mail.getStatus().length(), maxWidth);
        }
        StringBuffer sb = new StringBuffer();
        sb.append('+');
        FancymailCommands.replicate(sb, '-', fromWidth + 2);
        sb.append('+');
        FancymailCommands.replicate(sb, '-', toWidth + 2);
        sb.append('+');
        FancymailCommands.replicate(sb, '-', dateWidth + 2);
        sb.append('+');
        FancymailCommands.replicate(sb, '-', subjectWidth + 2);
        sb.append('+');
        FancymailCommands.replicate(sb, '-', sentWidth + 2);
        sb.append('+');
        FancymailCommands.replicate(sb, '-', statusWidth + 2);
        sb.append('+');
        String headLine = sb.toString();
        out.println(headLine);
        sb.setLength(0);
        sb.append("| ");
        FancymailCommands.padRight(sb, "From", fromWidth);
        sb.append(" | ");
        FancymailCommands.padRight(sb, "To", toWidth);
        sb.append(" | ");
        FancymailCommands.padLeft(sb, "Date", dateWidth);
        sb.append(" | ");
        FancymailCommands.padLeft(sb, "Subject", subjectWidth);
        sb.append(" | ");
        FancymailCommands.padLeft(sb, "Sent", sentWidth);
        sb.append(" | ");
        FancymailCommands.padLeft(sb, "Status", statusWidth);
        sb.append(" |");
        out.println(sb.toString());
        out.println(headLine);
        for (EMailReportDTO mail : mails) {
            sb.setLength(0);
            sb.append("| ");
            FancymailCommands.padRight(sb, mail.getSender(), fromWidth);
            sb.append(" | ");
            FancymailCommands.padRight(sb, FancymailCommands.formatEmailListShort(mail.getTo()), toWidth);
            sb.append(" | ");
            FancymailCommands.padLeft(sb, this.formatDate(mail.getCreated()), dateWidth);
            sb.append(" | ");
            FancymailCommands.padLeft(sb, mail.getSubject(), subjectWidth);
            sb.append(" | ");
            FancymailCommands.padLeft(sb, this.formatDate(mail.getSentAt()), sentWidth);
            sb.append(" | ");
            FancymailCommands.padLeft(sb, mail.getStatus(), statusWidth);
            sb.append(" |");
            out.println(sb.toString());
        }
        out.println(headLine);
        out.println(String.format("Found [%d] E-Mails.", mails.size()));
    }

    @Descriptor(value="List SMS senders.")
    public void listSMSSenders(PrintStream out) throws Exception {
        FancyMailServerSMSService svc = this.getFancyMailServerSMSService();
        List senders = svc.getAllSenders();
        int phoneWidth = 20;
        int prettyWidth = 20;
        for (SMSSenderDTO sender : senders) {
            if (sender.getSourceNumber() != null && sender.getSourceNumber().length() > phoneWidth) {
                phoneWidth = sender.getSourceNumber().length();
            }
            if (sender.getPersonalName() == null || sender.getPersonalName().length() <= prettyWidth) continue;
            prettyWidth = sender.getPersonalName().length();
        }
        StringBuffer sb = new StringBuffer();
        sb.append('+');
        FancymailCommands.replicate(sb, '-', phoneWidth + 2);
        sb.append('+');
        FancymailCommands.replicate(sb, '-', prettyWidth + 2);
        sb.append('+');
        String headLine = sb.toString();
        out.println(headLine);
        sb.setLength(0);
        sb.append("| ");
        FancymailCommands.padLeft(sb, "Phone", phoneWidth);
        sb.append(" | ");
        FancymailCommands.padLeft(sb, "Pretty Name", prettyWidth);
        sb.append(" |");
        out.println(sb.toString());
        out.println(headLine);
        for (SMSSenderDTO sender : senders) {
            sb.setLength(0);
            sb.append("| ");
            FancymailCommands.padLeft(sb, sender.getSourceNumber(), phoneWidth);
            sb.append(" | ");
            FancymailCommands.padLeft(sb, sender.getPersonalName(), prettyWidth);
            sb.append(" |");
            out.println(sb.toString());
        }
        out.println(headLine);
        out.println(String.format("Found [%d] SMS senders.", senders.size()));
    }

    @Descriptor(value="Insert an SMS sender.")
    public void insertSMSSender(PrintStream out, @Descriptor(value="Phone Number") @Argument(value="phone") String phone, @Descriptor(value="Pretty Name") @Argument(value="gecos") String pretty) {
        SMSSenderDTO sender = new SMSSenderDTO();
        sender.setSourceNumber(phone);
        sender.setPersonalName(pretty);
        FancyMailServerSMSService svc = this.getFancyMailServerSMSService();
        svc.insertSender(sender);
        out.println("Successfully inserted SMS sender for [" + phone + "]");
    }

    private static SMSDestinationDTO parseSMSAddress(String addr) {
        String trimmed = addr.trim();
        SMSDestinationDTO ret = new SMSDestinationDTO();
        if (trimmed.endsWith(">")) {
            int idx = trimmed.indexOf("<", 0);
            if (idx < 0) {
                throw new IllegalArgumentException("EMail Address [" + addr + "] ends with '>'' but does not contain '<'");
            }
            ret.setDestNumber(trimmed.substring(idx + 1, trimmed.length() - 1).trim());
            ret.setPersonalName(trimmed.substring(0, idx).trim());
        } else {
            ret.setDestNumber(trimmed);
        }
        if (!PHONE_NR_REGEX.matcher(ret.getDestNumber()).matches()) {
            throw new IllegalArgumentException("Specified a non-phone-nr [" + addr + "] as phone number (must match [" + String.valueOf(PHONE_NR_REGEX) + "]).");
        }
        return ret;
    }

    private static List<SMSDestinationDTO> parseSMSAddressList(String addr) {
        String[] parts = addr.trim().split("\\s*,\\s*");
        ArrayList<SMSDestinationDTO> ret = new ArrayList<SMSDestinationDTO>(parts.length);
        for (String part : parts) {
            if (part.length() <= 0) continue;
            ret.add(FancymailCommands.parseSMSAddress(part));
        }
        if (ret.size() == 0) {
            throw new IllegalArgumentException("EMail Address list [" + addr + "] does not contain any e-mail.");
        }
        return ret;
    }

    private static String formatSMSListShort(List<SMSDestinationDTO> addrs) {
        StringBuffer sb = new StringBuffer();
        for (SMSDestinationDTO addr : addrs) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(addr.getDestNumber());
        }
        return sb.toString();
    }

    @Descriptor(value="Send an SMS, some fields may be a comma-separated list of phone numbers.")
    public void sendSMS(PrintStream out, @Descriptor(value="Sender Phone Number") @Argument(value="from") String from, @Descriptor(value="Recipient Phone Number(s)") @Argument(value="to") String to, @Descriptor(value="Message Body") @Argument(value="body") String body) {
        SMSDTO sms = new SMSDTO();
        sms.setDestinations(FancymailCommands.parseSMSAddressList(to));
        sms.setSender(from);
        sms.setText(body);
        FancyMailServerSMSService svc = this.getFancyMailServerSMSService();
        svc.queueSMS(sms);
        out.println("Sucessfully queued SMS to [" + to + "].");
    }

    @Descriptor(value="List SMSs from database.")
    public void listSMSs(PrintStream out, @Descriptor(value="Start date to search for, default is two weeks before today") @Parameter(names={"-s", "--since"}, absentValue="\u00a0") String since, @Descriptor(value="End date to search for, default is no upper date limit") @Parameter(names={"-u", "--until"}, absentValue="\u00a0") String until, @Descriptor(value="Sender phone number to search for") @Parameter(names={"-f", "--from"}, absentValue="\u00a0") String from, @Descriptor(value="Recipient phone number to search for") @Parameter(names={"-t", "--to"}, absentValue="\u00a0") String to, @Descriptor(value="Maximal width of output columns") @Parameter(names={"-w", "--width"}, absentValue="40") int maxWidth) throws ParseException {
        Date sinceDate = NULL_STRING.equals(since) ? this.defaultDate(out) : this.parseDate(since);
        Date untilDate = NULL_STRING.equals(until) ? null : this.parseDate(until);
        FancyMailServerSMSService svc = this.getFancyMailServerSMSService();
        List smss = svc.getAllSMS(sinceDate, untilDate, NULL_STRING.equals(from) ? null : from, NULL_STRING.equals(to) ? null : to);
        int fromWidth = 20;
        int toWidth = 20;
        int dateWidth = 19;
        int sentWidth = 19;
        int subjectWidth = 20;
        int statusWidth = 20;
        for (SMSReportDTO sms : smss) {
            if (fromWidth < maxWidth && sms.getSender().length() > fromWidth) {
                fromWidth = Math.min(sms.getSender().length(), maxWidth);
            }
            int w = -1;
            for (SMSDestinationDTO toAddr : sms.getDestinations()) {
                w += 1 + toAddr.getDestNumber().length();
            }
            if (w > toWidth) {
                toWidth = Math.min(w, maxWidth);
            }
            if (subjectWidth < maxWidth && sms.getText().length() > subjectWidth) {
                subjectWidth = Math.min(sms.getText().length(), maxWidth);
            }
            if (statusWidth >= maxWidth || sms.getStatus().length() <= statusWidth) continue;
            statusWidth = Math.min(sms.getStatus().length(), maxWidth);
        }
        StringBuffer sb = new StringBuffer();
        sb.append('+');
        FancymailCommands.replicate(sb, '-', fromWidth + 2);
        sb.append('+');
        FancymailCommands.replicate(sb, '-', toWidth + 2);
        sb.append('+');
        FancymailCommands.replicate(sb, '-', dateWidth + 2);
        sb.append('+');
        FancymailCommands.replicate(sb, '-', subjectWidth + 2);
        sb.append('+');
        FancymailCommands.replicate(sb, '-', sentWidth + 2);
        sb.append('+');
        FancymailCommands.replicate(sb, '-', statusWidth + 2);
        sb.append('+');
        String headLine = sb.toString();
        out.println(headLine);
        sb.setLength(0);
        sb.append("| ");
        FancymailCommands.padRight(sb, "From", fromWidth);
        sb.append(" | ");
        FancymailCommands.padRight(sb, "To", toWidth);
        sb.append(" | ");
        FancymailCommands.padLeft(sb, "Date", dateWidth);
        sb.append(" | ");
        FancymailCommands.padLeft(sb, "Text", subjectWidth);
        sb.append(" | ");
        FancymailCommands.padLeft(sb, "Sent", sentWidth);
        sb.append(" | ");
        FancymailCommands.padLeft(sb, "Status", statusWidth);
        sb.append(" |");
        out.println(sb.toString());
        out.println(headLine);
        for (SMSReportDTO sms : smss) {
            sb.setLength(0);
            sb.append("| ");
            FancymailCommands.padRight(sb, sms.getSender(), fromWidth);
            sb.append(" | ");
            FancymailCommands.padRight(sb, FancymailCommands.formatSMSListShort(sms.getDestinations()), toWidth);
            sb.append(" | ");
            FancymailCommands.padLeft(sb, this.formatDate(sms.getCreated()), dateWidth);
            sb.append(" | ");
            FancymailCommands.padLeft(sb, sms.getText(), subjectWidth);
            sb.append(" | ");
            FancymailCommands.padLeft(sb, this.formatDate(sms.getSentAt()), sentWidth);
            sb.append(" | ");
            FancymailCommands.padLeft(sb, sms.getStatus(), statusWidth);
            sb.append(" |");
            out.println(sb.toString());
        }
        out.println(headLine);
        out.println(String.format("Found [%d] SMSs.", smss.size()));
    }
}

