package org.clazzes.fancymail.aws;

import org.clazzes.fancymail.sms.ISMSChannel;
import org.clazzes.svc.api.Component;
import org.clazzes.svc.api.ComponentManager;
import org.clazzes.svc.api.ComponentSupport;
import org.clazzes.svc.api.ConfigurationEngine;
import org.clazzes.svc.api.ConfigurationHelper;
import org.clazzes.svc.api.ServiceContext;
import org.clazzes.svc.api.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSSMSComponent extends ComponentSupport implements Component {

    private static final Logger log = LoggerFactory.getLogger(AWSSMSComponent.class);

    public static final String CONFIG_PID = "org.clazzes.fancymail.aws";

    @Override
    public void start(ServiceContext context) throws Exception {

        ServiceRegistry registry = context.getService(ServiceRegistry.class).get();
        ConfigurationEngine ce = context.getService(ConfigurationEngine.class).get();
        ComponentManager componentManager = context.getService(ComponentManager.class).get();

        this.addListener(ce.listen(CONFIG_PID,(config) -> {

            this.removeAllServices(registry);

            AWSSMSChannel channel = new AWSSMSChannel();

            channel.setSenderID(config.getString("senderID"));
            channel.setMaxPrice(config.getString("maxPrice"));
            channel.setSmsType(config.getString("smsType","Promotional"));
            channel.setSuppressOriginationNumber(config.getBoolean("suppressOriginationNumber",false));
            channel.setTimeoutSecs(config.getInt("timeoutSecs",15));

            log.info("Starting {}.",channel);

            this.addService(registry,"aws",ISMSChannel.class,channel);
            componentManager.commit();
        }));
    }

    @Override
    public void stop(ServiceContext context) throws Exception {

        ServiceRegistry registry = context.getService(ServiceRegistry.class).get();

        this.closeAllListeners();
        this.removeAllServices(registry);
    }

}
